#Include <Array.au3>
#Include <File.au3>
#Include <7Zip.au3>

Opt('MustDeclareVars', 1)

Global $Path = FileSelectFolder('Select Folder', "", 0, @ScriptDir)

If @error Or Not FileExists($Path) Then
    Exit
EndIf

Global $Ret, $Index, $Percent, $Count = 0, $Prev = 0, $Cache = _CacheRead($Path & '\cache.dat')
Global $iRecurse = 0, $FilesPath = $Path & "\"

If $iRecurse Then
	$FilesPath = ""
EndIf

Global $Timer = TimerInit()
Global $FileList = _FilesList($Path, '*.zip', $iRecurse)

If Not IsArray($FileList) Then
    MsgBox(16, 'Error', 'Not found .zip file(s).')
    Exit
EndIf

Dim $Data[500][4] = [[0]]

ProgressOn('Scaning...', 'Files: 0', '0 %')

For $i = 1 To $FileList[0]
    $Data[0][0] += 1
    If $Data[0][0] > UBound($Data) - 1 Then
        ReDim $Data[$Data[0][0] + 500][4]
    EndIf
    $Data[$Data[0][0]][0] = $FileList[$i]
    $Data[$Data[0][0]][1] = FileGetTime($FilesPath & $FileList[$i], 0, 1)
    $Data[$Data[0][0]][2] = FileGetSize($FilesPath & $FileList[$i])
    $Index = _CacheGetIndex($FileList[$i], $Cache)
    If ($Index) And ($Data[$Data[0][0]][1] = $Cache[$Index][1]) And ($Data[$Data[0][0]][2] = $Cache[$Index][2]) Then
        $Data[$Data[0][0]][3] = $Cache[$Index][3]
    Else
        $Data[$Data[0][0]][3] = _7ZipGetFileCount($FilesPath & $FileList[$i])
    EndIf
    $Count += $Data[$Data[0][0]][3]
    $Percent = Round($i / $FileList[0] * 20)
    If $Percent <> $Prev Then
        ProgressSet(5 * $Percent, (5 * $Percent) & ' %', 'Files: ' & $Count)
        $Prev = $Percent
    EndIf
Next

ProgressOff()

ReDim $Data[$Data[0][0] + 1][4]
_CacheWrite($Path & '\cache.dat', $Data)

MsgBox(0, 'Result', 'Files: ' & $Count & @CR & StringFormat('Elapsed: %.2f sec', TimerDiff($Timer) / 1000) & @CR)

Func _CacheGetIndex($sName, ByRef $aData)
    If IsArray($aData) Then
        For $i = 1 To $aData[0][0]
            If $aData[$i][4] Then
                If $aData[$i][0] = $sName Then
                    $aData[$i][4] = 0
                    Return $i
                EndIf
            EndIf
        Next
    EndIf
    Return 0
EndFunc

Func _CacheRead($sFile)
    Local $Data, $Item, $Cache = 0
    _FileReadToArray($sFile, $Data)
    If Not @error Then
        Dim $Cache[$Data[0] + 1][5] = [[0]]
        For $i = 1 To $Data[0]
            $Item = StringSplit($Data[$i], '|')
            If $Item[0] = 4 Then
                $Cache[0][0] += 1
                $Cache[$Cache[0][0]][0] = $Item[1]
                $Cache[$Cache[0][0]][1] = $Item[2]
                $Cache[$Cache[0][0]][2] = Number($Item[3])
                $Cache[$Cache[0][0]][3] = Number($Item[4])
                $Cache[$Cache[0][0]][4] = 1
            EndIf
        Next
        If $Cache[0][0] Then
            ReDim $Cache[$Cache[0][0] + 1][5]
        Else
            $Cache = 0
        EndIf
    EndIf
    Return $Cache
EndFunc

Func _CacheWrite($sFile, ByRef $aData)
    Local $Str = ''
    For $i = 1 To $aData[0][0]
        $Str &= $aData[$i][0] & '|' & $aData[$i][1] & '|' & $aData[$i][2] & '|' & $aData[$i][3] & @CRLF
    Next
    If Not FileWrite($sFile, StringTrimRight($Str, 2)) Then
        FileDelete($sFile)
        Return 0
    EndIf
    Return 1
EndFunc

Func _FilesList($sPath, $sFileMask, $iRecurse = 0)
	Local $sOut, $aOut, $hDir, $sRecurseStr = ""
	
	If $iRecurse Then
		$sRecurseStr = " /S"
	EndIf
	
	$sOut = StringToBinary("0" & @CRLF, 2)
	$hDir = Run(@ComSpec & ' /U /C DIR "' & $sPath & '\' & $sFileMask & '"' & $sRecurseStr & ' /B /A-D', @SystemDir, @SW_HIDE, 6)
	
	While 1
		$sOut &= StdoutRead($hDir, False, True)
		If @error Then ExitLoop
	WEnd
	
	$aOut = StringRegExp(BinaryToString($sOut, 2), "[^\r\n]+", 3)
	If @error Then Return SetError(1)
	
	$aOut[0] = UBound($aOut) - 1
	Return $aOut
EndFunc
